#Notes for configuring the Digital Video Terminal + Terminal BackPack with MicroPython, see MicroPython RPI_PICO-20240602-v1.23.0.uf2

#Serial console
import uos
from machine import UART, Pin
repl_uart = UART(0, baudrate=115200, tx=Pin(0), rx=Pin(1))
uos.dupterm(repl_uart, 0)

#I2C
from machine import Pin, I2C
i2c = I2C(1, scl=Pin(3), sda=Pin(2), freq=100000)
i2c.scan()

#I2S, see https://github.com/miketeachman/micropython-i2s-examples/blob/master/examples/play_tone.py
from machine import Pin, I2S
#change pins to:
SCK_PIN = 5
WS_PIN = 6
SD_PIN = 4

#microSD card
#driver: https://github.com/micropython/micropython/blob/v1.19/drivers/sdcard/sdcard.py
from machine import SPI, Pin
import uos
import sdcard
spi0 = SPI(0,sck=Pin(18), mosi=Pin(19), miso=Pin(16))
sd = sdcard.SDCard(spi0, Pin(21))
vfs = uos.VfsFat(sd)
uos.mount(vfs, "/sd")

